local positions = {
	-- trapdoors
	{x = 33386, y = 31139, z = 8},
	{x = 33387, y = 31139, z = 8},
	{x = 33388, y = 31139, z = 8},--1
	{x = 33386, y = 31134, z = 8},
	{x = 33387, y = 31134, z = 8},
	{x = 33388, y = 31134, z = 8},--2
	{x = 33386, y = 31126, z = 8},
	{x = 33387, y = 31126, z = 8},
	{x = 33388, y = 31126, z = 8},--3
	{x = 33386, y = 31119, z = 8},
	{x = 33387, y = 31119, z = 8},
	{x = 33388, y = 31119, z = 8},--4
	{x = 33386, y = 31118, z = 8},
	{x = 33387, y = 31118, z = 8},
	{x = 33388, y = 31118, z = 8},--5
	{x = 33381, y = 31093, z = 8},
	{x = 33382, y = 31093, z = 8},
	{x = 33383, y = 31093, z = 8},--6
	{x = 33381, y = 31085, z = 8},
	{x = 33382, y = 31085, z = 8}, --7
	-- message
	{x = 33383, y = 31110, z = 8},
	{x = 33383, y = 31111, z = 8},
	{x = 33383, y = 31112, z = 8},
	{x = 33383, y = 31113, z = 8},
	{x = 33383, y = 31114, z = 8},
	-- trap
	-- stage1
	{x = 33382, y = 31110, z = 8},
	{x = 33381, y = 31110, z = 8},
	{x = 33380, y = 31110, z = 8},
	{x = 33382, y = 31109, z = 8},
	{x = 33380, y = 31109, z = 8},
	{x = 33382, y = 31108, z = 8},
	{x = 33381, y = 31108, z = 8},
	{x = 33380, y = 31108, z = 8},--1lamp
	{x = 33378, y = 31111, z = 8},
	{x = 33377, y = 31111, z = 8},
	{x = 33376, y = 31111, z = 8},
	{x = 33378, y = 31112, z = 8},
	{x = 33376, y = 31112, z = 8},
	{x = 33378, y = 31110, z = 8},
	{x = 33377, y = 31110, z = 8},
	{x = 33376, y = 31110, z = 8},--2lamp
	{x = 33375, y = 31109, z = 8},
	{x = 33374, y = 31109, z = 8},
	{x = 33373, y = 31109, z = 8},
	{x = 33375, y = 31108, z = 8},
	{x = 33375, y = 31107, z = 8},
	{x = 33374, y = 31107, z = 8},
	{x = 33373, y = 31107, z = 8},--3lamp
	{x = 33379, y = 31106, z = 8},
	{x = 33378, y = 31106, z = 8},
	{x = 33377, y = 31106, z = 8},
	{x = 33379, y = 31105, z = 8},
	{x = 33377, y = 31105, z = 8},
	{x = 33379, y = 31104, z = 8},
	{x = 33378, y = 31104, z = 8},
	{x = 33377, y = 31104, z = 8},--4lamp/1guard
	{x = 33382, y = 31103, z = 8},
	{x = 33381, y = 31103, z = 8},
	{x = 33380, y = 31103, z = 8},
	{x = 33382, y = 31102, z = 8},
	{x = 33380, y = 31102, z = 8},
	{x = 33382, y = 31101, z = 8},
	{x = 33381, y = 31101, z = 8},
	{x = 33380, y = 31101, z = 8},--5lamp
	{x = 33377, y = 31102, z = 8},
	{x = 33376, y = 31102, z = 8},
	{x = 33375, y = 31102, z = 8},
	{x = 33377, y = 31101, z = 8},
	{x = 33377, y = 31100, z = 8},--6lamp
	{x = 33384, y = 31099, z = 8},
	{x = 33383, y = 31099, z = 8},
	{x = 33382, y = 31099, z = 8},
	{x = 33384, y = 31098, z = 8},
	{x = 33382, y = 31098, z = 8},
	{x = 33384, y = 31097, z = 8},
	{x = 33383, y = 31097, z = 8},
	{x = 33382, y = 31097, z = 8},--7lamp/2guard
	-- stage2
	{x = 33386, y = 31080, z = 8},
	{x = 33385, y = 31080, z = 8},
	{x = 33384, y = 31080, z = 8},
	{x = 33386, y = 31079, z = 8},
	{x = 33384, y = 31079, z = 8},
	{x = 33386, y = 31078, z = 8},
	{x = 33385, y = 31078, z = 8},
	{x = 33384, y = 31078, z = 8},--1lamp/1guard
	{x = 33389, y = 31079, z = 8},
	{x = 33388, y = 31079, z = 8},
	{x = 33387, y = 31079, z = 8},
	{x = 33389, y = 31078, z = 8},
	{x = 33387, y = 31078, z = 8},
	{x = 33389, y = 31077, z = 8},
	{x = 33388, y = 31077, z = 8},
	{x = 33387, y = 31077, z = 8},--2lamp
	{x = 33383, y = 31077, z = 8},
	{x = 33382, y = 31077, z = 8},
	{x = 33381, y = 31077, z = 8},
	{x = 33383, y = 31076, z = 8},
	{x = 33381, y = 31076, z = 8},
	{x = 33383, y = 31075, z = 8},
	{x = 33382, y = 31075, z = 8},
	{x = 33381, y = 31075, z = 8},--3lamp
	{x = 33390, y = 31075, z = 8},
	{x = 33389, y = 31075, z = 8},
	{x = 33388, y = 31075, z = 8},
	{x = 33390, y = 31074, z = 8},
	{x = 33388, y = 31074, z = 8},
	{x = 33390, y = 31073, z = 8},
	{x = 33389, y = 31073, z = 8},
	{x = 33388, y = 31073, z = 8},--4lamp
	{x = 33386, y = 31074, z = 8},
	{x = 33385, y = 31074, z = 8},
	{x = 33384, y = 31074, z = 8},
	{x = 33386, y = 31073, z = 8},
	{x = 33384, y = 31073, z = 8},
	{x = 33386, y = 31072, z = 8},
	{x = 33385, y = 31072, z = 8},
	{x = 33384, y = 31072, z = 8},--5lamp
	{x = 33393, y = 31073, z = 8},
	{x = 33392, y = 31073, z = 8},
	{x = 33391, y = 31073, z = 8},
	{x = 33383, y = 31073, z = 8},
	{x = 33382, y = 31073, z = 8},
	{x = 33381, y = 31073, z = 8},
	{x = 33391, y = 31072, z = 8},
	{x = 33383, y = 31072, z = 8},
	{x = 33381, y = 31072, z = 8},
	{x = 33392, y = 31071, z = 8},
	{x = 33391, y = 31071, z = 8},
	{x = 33383, y = 31071, z = 8},
	{x = 33382, y = 31071, z = 8},
	{x = 33381, y = 31071, z = 8},--6/7lamp
	{x = 33389, y = 31071, z = 8},
	{x = 33388, y = 31071, z = 8},
	{x = 33387, y = 31071, z = 8},
	{x = 33389, y = 31070, z = 8},
	{x = 33387, y = 31070, z = 8},
	{x = 33389, y = 31069, z = 8},
	{x = 33388, y = 31069, z = 8},
	{x = 33387, y = 31069, z = 8},--8lamp
	{x = 33384, y = 31070, z = 8},
	{x = 33383, y = 31070, z = 8},
	{x = 33382, y = 31070, z = 8},
	{x = 33384, y = 31069, z = 8},
	{x = 33382, y = 31069, z = 8},
	{x = 33384, y = 31068, z = 8},
	{x = 33383, y = 31068, z = 8},
	{x = 33382, y = 31068, z = 8},--9lamp/2guarda
	{x = 33368, y = 31079, z = 8},
	{x = 33367, y = 31079, z = 8},
	{x = 33366, y = 31079, z = 8},
	{x = 33368, y = 31078, z = 8},
	{x = 33366, y = 31078, z = 8},
	{x = 33368, y = 31077, z = 8},
	{x = 33367, y = 31077, z = 8},
	-- stage3
	{x = 33366, y = 31077, z = 8},--1lamp
	{x = 33370, y = 31080, z = 8},
	{x = 33369, y = 31080, z = 8},
	{x = 33368, y = 31080, z = 8},
	{x = 33370, y = 31079, z = 8},
	{x = 33370, y = 31078, z = 8},
	{x = 33369, y = 31078, z = 8},--2lamp
	{x = 33361, y = 31082, z = 8},
	{x = 33361, y = 31081, z = 8},
	{x = 33359, y = 31081, z = 8},
	{x = 33361, y = 31080, z = 8},
	{x = 33360, y = 31080, z = 8},
	{x = 33359, y = 31080, z = 8},--3lamp
	{x = 33368, y = 31084, z = 8},
	{x = 33367, y = 31084, z = 8},
	{x = 33366, y = 31084, z = 8},
	{x = 33368, y = 31083, z = 8},
	{x = 33366, y = 31083, z = 8},
	{x = 33368, y = 31082, z = 8},
	{x = 33367, y = 31082, z = 8},
	{x = 33366, y = 31082, z = 8},--4lamp/1guard
	-- lights 1
	{x = 33368, y = 31075, z = 8},
	{x = 33369, y = 31075, z = 8},
	{x = 33370, y = 31075, z = 8},
	{x = 33371, y = 31075, z = 8},
	{x = 33372, y = 31075, z = 8},
	{x = 33373, y = 31075, z = 8},
	{x = 33374, y = 31075, z = 8},
	{x = 33375, y = 31075, z = 8},
	-- lights 2
	{x = 33356, y = 31076, z = 8},
	{x = 33356, y = 31077, z = 8},
	{x = 33356, y = 31078, z = 8},
	{x = 33357, y = 31076, z = 8},
	{x = 33357, y = 31077, z = 8},
	{x = 33357, y = 31078, z = 8},
	{x = 33358, y = 31077, z = 8},
	{x = 33358, y = 31078, z = 8},
	{x = 33359, y = 31078, z = 8},
	{x = 33359, y = 31079, z = 8},
	{x = 33360, y = 31078, z = 8},
	{x = 33360, y = 31079, z = 8},
	{x = 33361, y = 31078, z = 8},
	{x = 33361, y = 31079, z = 8},
	-- lights 3
	{x = 33345, y = 31074, z = 8},
	{x = 33345, y = 31075, z = 8},
	{x = 33346, y = 31074, z = 8},
	{x = 33346, y = 31075, z = 8},
	{x = 33347, y = 31073, z = 8},
	{x = 33347, y = 31074, z = 8},
	{x = 33347, y = 31075, z = 8},
	-- check
	{x = 33323, y = 31080, z = 7}
}

function catchPlayer(player)
	player:removeCondition(CONDITION_OUTFIT)
	player:removeItem(11328, 1)
	player:setStorageValue(Storage.WrathoftheEmperor.GuardcaughtYou, 1)
	player:teleportTo({x = 33361, y = 31206, z = 8}, false)
	player:say("The guards have spotted you. You were forcibly dragged into a small cell. It looks like you need to build another disguise.", TALKTYPE_MONSTER_SAY)
	return true
end

local trapDoors =
{
	{doorPos = Position(33385, 31139, 8)},
	{doorPos = Position(33385, 31134, 8)},
	{doorPos = Position(33385, 31126, 8)},
	{doorPos = Position(33385, 31119, 8)},
	{doorPos = Position(33385, 31118, 8)},
	{doorPos = Position(33380, 31093, 8)},
	{doorPos = Position(33380, 31085, 8)}
}

local crate = MoveEvent()

function crate.onStepIn(creature, item, position, fromPosition, toPosition)
	local player = Player(creature)
	if not player then
		return false
	end

	for j = 1, #positions do
		if j <= 20 then
			if player:getPosition() == Position(positions[j]) then
				if player:getOutfit().lookTypeEx ~= 11328 then
					return catchPlayer(player)
				end
				for i = 1, #trapDoors do
					local pos = trapDoors[i].doorPos
					if isInArray({Position(pos.x+1, pos.y, 8), Position(pos.x+2, pos.y, 8), Position(pos.x+3, pos.y, 8)}, player:getPosition()) and Tile(pos):getItemById(11257) then
						catchPlayer(player)
					end
				end
			end
		elseif j >= 21 and j <= 25 then
			if player:getPosition() == Position(positions[j]) and player:getStorageValue(Storage.WrathoftheEmperor.Message) ~= 1 then
				player:say("Guards heavily patrol this area. Try to stay hidden and do not draw any attention to yourself by trying to attack.", TALKTYPE_MONSTER_SAY)
				player:setStorageValue(Storage.WrathoftheEmperor.Message, 1)
			end
		elseif j >= 26 and j <= 175 then
			if player:getPosition() == Position(positions[j]) then
				catchPlayer(player)
			end
		elseif j >= 176 and j <= 183 then
			if player:getPosition() == Position(positions[j]) then
				if Game.getStorageValue(GlobalStorage.WrathOfTheEmperor.Light01) ~= 1 then
					catchPlayer(player)
				end
			end
		elseif j >= 184 and j <= 197 then
			if player:getPosition() == Position(positions[j]) then
				if Game.getStorageValue(GlobalStorage.WrathOfTheEmperor.Light02) ~= 1 then
					catchPlayer(player)
				end
			end
		elseif j >= 198 and j <= 204 then
			if player:getPosition() == Position(positions[j]) then
				if Game.getStorageValue(GlobalStorage.WrathOfTheEmperor.Light03) ~= 1 then
					catchPlayer(player)
				end
			end
		elseif j == 205 then
			if player:getPosition() == Position(positions[j]) then
				if player:removeCondition(CONDITION_OUTFIT) then
					player:say("On reaching the watchtower you remove your temporary disguise.", TALKTYPE_MONSTER_SAY)
				end
			end
		end
	end
	return true
end

crate:type("stepin")
for index, value in pairs(positions) do
	crate:position(value)
end
crate:register()
